<?php

session_start();

require __DIR__ . '/vendor/autoload.php';

$provider = new \League\OAuth2\Client\Provider\Braincube([
    'clientId'          => '{braincube-app-id}', // The client ID assigned to you by the provider
    'clientSecret'      => '{braincube-app-secret}', // The client password assigned to you by the provider
    'redirectUri'       => 'https://example.com/callback-url'
]);

// If we don't have an authorization code then get one
if (!isset($_GET['code'])) {

    if (isset($_SESSION['token'])) {
        unset($_SESSION['token']);
    }

    // Fetch the authorization URL from the provider; this returns the
    // urlAuthorize option and generates and applies any necessary parameters
    // (e.g. state).
    $authorizationUrl = $provider->getAuthorizationUrl();

    // Get the state generated for you and store it to the session.
    $_SESSION['oauth2state'] = $provider->getState();

    echo '<a href="'.$authorizationUrl.'">Log in with Braincube!</a>';
    exit;

// Check given state against previously stored one to mitigate CSRF attack
} elseif (empty($_GET['state']) || ($_GET['state'] !== $_SESSION['oauth2state'])) {

    if (isset($_SESSION['oauth2state'])) {
            unset($_SESSION['oauth2state']);
    }

    exit('Invalid state');

} else {

    try {

        if (isset($_SESSION['token'])) {
            echo 'Access Token: ' . $_SESSION['token'] . "<br>";
            echo '<a href="/">Logout!</a>';
        } else {
            // Try to get an access token using the authorization code grant.
            $accessToken = $provider->getAccessToken('authorization_code', [
                'code' => $_GET['code']
            ]);
    
            // We have an access token, which we may use in authenticated
            // requests against the service provider's API.
            echo 'Access Token: ' . $accessToken->getToken() . "<br>";
            echo 'Refresh Token: ' . $accessToken->getRefreshToken() . "<br>";
            echo 'Expired in: ' . $accessToken->getExpires() . "<br>";
            echo 'Already expired? ' . ($accessToken->hasExpired() ? 'expired' : 'not expired') . "<br>";
    
            // Using the access token, we may look up details about the
            // resource owner.
            $resourceOwner = $provider->getResourceOwner($accessToken);
    
            prettify($resourceOwner->toArray());
    
            // The provider provides a way to get an authenticated API request for
            // the service, using the access token; it returns an object conforming
            // to Psr\Http\Message\RequestInterface.
            $request = $provider->getAuthenticatedRequest(
                'GET',
                'https://yourapi',
                $accessToken
            );
     
            $response = $provider->getParsedResponse($request);
            prettify($response);
    
            $_SESSION['token'] = $accessToken->getToken();
        }

    } catch (\League\OAuth2\Client\Provider\Exception\IdentityProviderException $e) {

        // Failed to get the access token or user details.
        exit($e->getMessage());

    }

}

function prettify($code) {
    echo "<pre>";
    var_export($code);
    echo "</pre>";
}
